* 06 Figure 5-7.do;
*version 17
#d ;
clear;
cap log close;
set more off;
set type double;
set scheme s1color;
set linesize 100;
local xyear=2019;
pause on;

cap log close;
log using "${log}06 Figure 5-7.log", replace;
use "${CE}/ce_cpc_comb_haall_v7.dta", clear;
count;

* after tax with SNAP;
gen c_rinc_aftertax=c_rfinc_addfsm-c_rtaxm2;
gen c_poor_rinc_aftertax=c_rinc_aftertax<c_rspm_thres if c_rspm_thres<.;

gen c_rinc_aftertax_net = (c_rinc_aftertax) + (c_rinkind) - (c_rchildsupport + c_rCapWknChCareXpns + c_rhealth) ; 
gen c_poor_rinc_aftertax_net = c_rinc_aftertax_net < c_rspm_thres if c_rspm_thres<.;

gen c_rexpk_nok = c_rexpk - c_rsnap;
gen c_poor_rexpk_nok = c_rexpk_nok < c_rspm_thres if c_rspm_thres<.;
gen c_rinc_aftertax_net_nok = c_rinc_aftertax_net - c_rsnap ; 
gen c_poor_rinc_aftertax_net_nok = c_rinc_aftertax_net_nok < c_rspm_thres if c_rspm_thres<.;


gen c_test = (c_rinc_aftertax) + (c_rinkind - c_rsnap) - (c_rchildsupport + c_rCapWknChCareXpns + c_rhealth) ; 
gen c_poor_test = c_test < c_rspm_thres if c_rspm_thres<.;

***************;
* to match CE we should exclude 7 states FIPS 19,35,38,50,56,44,40 where there is no CE data.
* unfortunately our original CPSP data does not include State.  So the samples states differ.;

*************************
* time series graphs;
************************;
keep if year>=2004 & c_house_grp>0;
* poverty rates, adjusted income;
preserve;
  collapse (mean) c_poor_metadj c_poor_rinc_official c_poor_rexp_noknoadj c_poor_rinc_noknoadj c_poor_off_cpsfile c_poor_rinc_aftertax ///
  c_poor_rexp_knoadj c_poor_knoadj c_rsnap ///
   c_rtaxm2 c_rfica c_rhealth c_rCapWknChCareXpns c_rchildsupport c_poor_rinck ///
  c_poor_rexpk c_rinkind c_rinc_aftertax c_poor_metadj_anch_cen c_poor_anc_rinck c_poor_anc_rexpk ///
  c_rinc_aftertax_net c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok c_test c_poor_test c_pdeep* c_pnear* /// 
  [aweight=c_perpopwt], by(asecsurvey year);

  * Fig 4new   Deep and Near poverty resources;
  for var c_poor_rexpk c_pdeep_rexpk c_pnear_rexpk c_poor_rinck c_pdeep_rinck c_pnear_rinck : replace X = X * 100 ; 
  twoway
  (line c_poor_rexpk year if asecsurvey==0, color(red)) ///
  (line c_poor_rinck year if asecsurvey==1, color(blue)) ///
  (line c_pdeep_rexpk year if asecsurvey==0, color(red%50)lpattern(dash)) ///
  (line c_pdeep_rinck year if asecsurvey==1, color(blue%50)lpattern(dash)) ///
  (line c_pnear_rexpk year if asecsurvey==0, color(red%50) lpattern(shortdash_dot)) ///
  (line c_pnear_rinck year if asecsurvey==1, color(blue%50) lpattern(shortdash_dot)), ///
  title("Figure 6: Near and Deep Net Poverty Rates, 2004–2019" " ", size(11pt)) ///
  ytitle("Poverty Rate (%)" "") ylabel(0(5)40,format(%3.0fc) labsize(small) angle(0)) ///
  xtitle("") xlabel(,labsize(small)) ///
  legend(size(small) label(1 "SEPM") label(3 "Deep Poverty SEPM")  ///
  label(5 "Near Poverty SEPM") label(2 "SIPM") label(4 "Deep Poverty SIPM") label(6 "Near Poverty SIPM")) ///
  note("Notes: SEPM based on adjusted expenditure < SPM threshold.  SIPM based on adjusted income < SPM threshold. An individual is in deep" "poverty if their adjusted resources are less than 50% of the poverty threshold. An individual is in near poverty if their adjusted resources are" "less than 150% of the poverty threshold. Resources include SNAP and three in-kind transfers and excludes three types of capped" "adjustments (work-related and child care costs, child support paid, and medical out of pocket expense).", size(vsmall) span)  ///
  saving("${outgraph}06 Near and Deep Poverty Rates (Figure 6 C).gph", replace);
  graph export "${outgraph}06 Near and Deep Poverty Rates (Figure 6 C).pdf",replace;

  twoway
  (line c_poor_rexpk year if asecsurvey==0, color(gray)) ///
  (line c_poor_rinck year if asecsurvey==1, color(gray%50)) ///
  (line c_pdeep_rexpk year if asecsurvey==0, color(gray) lpattern(dash)) ///
  (line c_pdeep_rinck year if asecsurvey==1, color(gray%50) lpattern(dash)) ///
  (line c_pnear_rexpk year if asecsurvey==0, color(gray) lpattern(shortdash_dot)) ///
  (line c_pnear_rinck year if asecsurvey==1, color(gray%50) lpattern(shortdash_dot)), ///
  title("Figure 6: Near and Deep Net Poverty Rates, 2004–2019" " ", size(11pt)) ///
  ytitle("Poverty Rate (%)" "") ylabel(0(5)40,format(%3.0fc) labsize(small) angle(0)) ///
  xtitle("") xlabel(,labsize(small)) ///
  legend(size(small) label(1 "SEPM") label(3 "Deep Poverty SEPM")  ///
  label(5 "Near Poverty SEPM") label(2 "SIPM") label(4 "Deep Poverty SIPM") label(6 "Near Poverty SIPM")) ///
  note("Notes: SEPM based on adjusted expenditure < SPM threshold.  SIPM based on adjusted income < SPM threshold. An individual is in deep" "poverty if their adjusted resources are less than 50% of the poverty threshold. An individual is in near poverty if their adjusted resources are" "less than 150% of the poverty threshold. Resources include SNAP and three in-kind transfers and excludes three types of capped" "adjustments (work-related and child care costs, child support paid, and medical out of pocket expense).", size(vsmall) span)  ///
  saving("${outgraph}06 Near and Deep Poverty Rates (Figure 6 BW).gph", replace);
  graph export "${outgraph}06 Near and Deep Poverty Rates (Figure 6 BW).pdf",replace;

  * Fig 5  After tax  and net poverty resources;
  for var c_poor_rexp_noknoadj c_poor_rinc_aftertax  c_poor_rinc_aftertax_net : replace X = X * 100 ; 
  twoway
  (line c_poor_rexp_noknoadj year if asecsurvey==0, color(red)) ///
  (line c_poor_rinc_aftertax year if asecsurvey==1, color(blue)) ///
  (line c_poor_rexpk year if asecsurvey==0, color(red%50) lpattern(dash)) ///
  (line c_poor_rinc_aftertax_net year if asecsurvey==1, color(blue%50) lpattern(dash)), ///
  title("Figure 5: SEPM and SIPM Poverty Rates," "Gross and Net, 2004–2019" " ", size(11pt)) ///
  ytitle("Poverty Rate (%)" "") ylabel(5(5)20,format(%3.0fc) labsize(small) angle(0)) ///
  xtitle("") xlabel(,labsize(small)) ///
  legend(size(small) label(1 "Gross SEPM") label(2 "Gross Adjusted SIPM")  ///
  label(3 "Net SEPM") label(4 "Net SIPM")) ///
  note("Notes: Gross SEPM poverty rate is based on total household spending on all items in the year. Gross Adjusted SIPM poverty rate is based on" "total income in the year after-tax and with SNAP benefits added. Net poverty rates are based on total spending and income after tax and with" "SNAP that include three in-kind transfers and excludes three types of capped adjustments (work-related and child care costs, child support" "paid, and medical out of pocket expense).", size(vsmall) span)  ///
  saving("${outgraph}06 SEPM and SIPM Poverty Rates (Figure 5 C).gph", replace);
  graph export "${outgraph}06 SEPM and SIPM Poverty Rates (Figure 5 C).pdf",replace;

  twoway
  (line c_poor_rexp_noknoadj year if asecsurvey==0, color(gray)) ///
  (line c_poor_rinc_aftertax year if asecsurvey==1, color(gray%50)) ///
  (line c_poor_rexpk year if asecsurvey==0, color(gray) lpattern(dash)) ///
  (line c_poor_rinc_aftertax_net year if asecsurvey==1, color(gray%50) lpattern(dash)), ///
  title("Figure 5: SEPM and SIPM Poverty Rates," "Gross and Net, 2004–2019" " ", size(11pt)) ///
  ytitle("Poverty Rate (%)" "") ylabel(5(5)20,format(%3.0fc) labsize(small) angle(0)) ///
  xtitle("") xlabel(,labsize(small)) ///
  legend(size(small) label(1 "Gross SEPM") label(2 "Gross Adjusted SIPM")  ///
  label(3 "Net SEPM") label(4 "Net SIPM")) ///
  note("Notes: Gross SEPM poverty rate is based on total household spending on all items in the year. Gross Adjusted SIPM poverty rate is based on" "total income in the year after-tax and with SNAP benefits added. Net poverty rates are based on total spending and income after tax and with" "SNAP that include three in-kind transfers and excludes three types of capped adjustments (work-related and child care costs, child support" "paid, and medical out of pocket expense).", size(vsmall) span)  ///
  saving("${outgraph}06 SEPM and SIPM Poverty Rates (Figure 5 BW).gph", replace);
  graph export "${outgraph}06 SEPM and SIPM Poverty Rates (Figure 5 BW).pdf",replace;

  list year  c_poor_rexp_noknoadj c_poor_rexpk  if asecsurvey==0 ; 
  list year c_poor_rinc_aftertax c_poor_rinc_aftertax_net if asecsurvey==1 ; 

restore ; 

* means for children, c_princk_xfhlwc is without snap and other inkind aid;
* define poverty rates with and without transfers;
* resources without transfers.  transfers have no missings;
gen c_rinck_xf=c_rinck - c_rsnap;
gen c_rinck_xfh = c_rinck_xf-c_rhousesub;
gen c_rinck_xfhl = c_rinck_xfh-c_rschlunch;
gen c_rinck_xfhlw = c_rinck_xfhl-c_rwic;
gen c_rinck_xfhlwe = c_rinck_xfhlw-c_rliheap;

gen c_princk_xf= c_rinck_xf < c_rspm_thres; 
gen c_princk_xfh = c_rinck_xfh < c_rspm_thres;
gen c_princk_xfhl = c_rinck_xfhl < c_rspm_thres;
gen c_princk_xfhlw = c_rinck_xfhlw < c_rspm_thres;
gen c_princk_xfhlwe = c_rinck_xfhlwe < c_rspm_thres;

gen c_rexpk_xf=c_rexpk - c_rsnap;
gen c_rexpk_xfh = c_rexpk_xf-c_rhousesub;
gen c_rexpk_xfhl = c_rexpk_xfh-c_rschlunch;
gen c_rexpk_xfhlw = c_rexpk_xfhl-c_rwic;
gen c_rexpk_xfhlwe = c_rexpk_xfhlw-c_rliheap;

gen c_prexpk_xf= c_rexpk_xf < c_rspm_thres; 
gen c_prexpk_xfh = c_rexpk_xfh < c_rspm_thres;
gen c_prexpk_xfhl = c_rexpk_xfhl < c_rspm_thres;
gen c_prexpk_xfhlw = c_rexpk_xfhlw < c_rspm_thres;
gen c_prexpk_xfhlwe = c_rexpk_xfhlwe < c_rspm_thres;
gen c_chldpres= c_nchild>0 & c_nchild<.;

preserve;
  collapse c_poor_rexpk c_poor_rinck c_princk_x* c_prexpk_x* c_poor_rinc_aftertax c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok [aweight=c_chldweight] if c_chldpres==1, by(asecsurvey year );
  list;

  for var c_poor_rexpk c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok : replace X = X * 100;

  keep year  asecsurvey c_poor_rexpk c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok ;
  for var c_poor_rexpk c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok : ren X X_CH ;
  save "${temp}06 Child rates.dta", replace ;
  
restore, preserve;

  * means for elderly ref person;
  collapse c_poor_rexpk c_poor_rinck c_princk_x* c_prexpk_x* c_poor_rinc_aftertax c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok [aweight=c_ot64weight] if elderly==1, by(asecsurvey year );
  list;

  for var c_poor_rexpk c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok : replace X = X * 100;

  keep year asecsurvey c_poor_rexpk c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok ;
  for var c_poor_rexpk c_poor_rinc_aftertax_net c_poor_rexpk_nok c_poor_rinc_aftertax_net_nok : ren X X_EL ;
  save "${temp}06 Elderly rates.dta", replace ; 

restore, preserve ; 

 use "${temp}06 Child rates.dta", clear ;
 merge 1:1 year asecsurvey using  "${temp}06 Elderly rates.dta", assert(3) nogen ;
 
 twoway 
 (line c_poor_rexpk_CH year if asecsurvey==0, color(red) ) ///
 (line c_poor_rexpk_EL year if asecsurvey==0, color(red%50) lpattern(dash) )
 (line c_poor_rinc_aftertax_net_CH year if asecsurvey==1, color(blue) ) 
 (line c_poor_rinc_aftertax_net_EL year if asecsurvey==1, color(blue%50) lpattern(dash) ),
 title("Figure 7: Net SEPM and SIPM Poverty Rates," "Children and Elderly, 2004–2019" " ", size(11pt)) ///
 ytitle("Poverty Rate (%)" "") ylabel(5(5)25,format(%3.0fc) labsize(small) angle(0)) ///
 xtitle("") xlabel(,labsize(small)) ///
 legend(size(small) label(1 "Net SEPM Children") label(2 "Net SEPM Elderly")  ///
 label(3 "Net SIPM Children") label(4 "Net SIPM Elderly")) ///
 note("Notes: Net poverty rates are based on total spending and income after tax and with SNAP that include three in-kind transfers and" "excludes three types of capped adjustments (work-related and child care costs, child support paid, and medical out of pocket expense).", size(vsmall) span) ///
 saving("${outgraph}06 Child and Elderly Poverty Rates (Figure 7 C).gph", replace);
 graph export "${outgraph}06 Child and Elderly Poverty Rates (Figure 7 C).pdf",replace;

twoway 
(line c_poor_rexpk_CH year if asecsurvey==0, color(gray) ) ///
(line c_poor_rexpk_EL year if asecsurvey==0, color(gray) lpattern(dash) )
(line c_poor_rinc_aftertax_net_CH year if asecsurvey==1, color(gray%50) ) 
(line c_poor_rinc_aftertax_net_EL year if asecsurvey==1, color(gray%50) lpattern(dash) ),
title("Figure 7: Net SEPM and SIPM Poverty Rates," "Children and Elderly, 2004–2019" " ", size(11pt)) ///
ytitle("Poverty Rate (%)" "") ylabel(5(5)25,format(%3.0fc) labsize(small) angle(0)) ///
xtitle("") xlabel(,labsize(small)) ///
legend(size(small) label(1 "Net SEPM Children") label(2 "Net SEPM Elderly")  ///
label(3 "Net SIPM Children") label(4 "Net SIPM Elderly")) ///
note("Notes: Net poverty rates are based on total spending and income after tax and with SNAP that include three in-kind transfers and" "excludes three types of capped adjustments (work-related and child care costs, child support paid, and medical out of pocket expense).", size(vsmall) span) ///
saving("${outgraph}06 Child and Elderly Poverty Rates (Figure 7 BW).gph", replace);
graph export "${outgraph}06 Child and Elderly Poverty Rates (Figure 7 BW).pdf",replace;

list year c_poor_rexpk_CH c_poor_rexpk_EL if asec==0;
list year c_poor_rinc_aftertax_net_CH c_poor_rinc_aftertax_net_EL if asec==1;
restore; 

log close;

* EOF

